#!/bin/bash

## simple wrapper for evaluation w/ iterative adoption of threshold as needed

innovus_bin=$1

threshold=19
iterate=no

while true; do

	echo "Trying w/ threshold of $threshold ..."

	echo "set threshold $threshold" > exploit_eval_threshold.tcl

	# subshell w/ same PID as process; simplifies killing process if needed
	sh -c 'echo $$ > PID.exploit_eval; exec '$(echo $innovus_bin)' -stylus -files exploit_eval.tcl -log exploit_eval > /dev/null 2>&1'

	grep -q "Exploit Region" exploit_regions.rpt 2> /dev/null

	if [[ $? != 0 ]]; then

		echo " No region is found or reports file is not ready (due to processing error) -- reduce threshold and possibly try again"
		((threshold = threshold - 1))
	else
		echo " Some region(s) found -- break/stop loop"
		break
	fi

	if [[ -e KILLED.exploit_eval ]]; then
		echo " Innovus process was killed due to some error -- break/kill loop as well"
		break
	fi

	if [[ $iterate != "yes" ]]; then
		echo " Script setup is to NOT iterate -- break/stop loop even though no region is found yet"
		break
	fi
done

## post-process regions
./post_process_exploit_regions.sh

## also extract design cost; basic eval (init_eval.tcl) is done at the start of exploit_eval.tcl, once the db is initialized w/ timing and all
## NOTE the underlying init_eval.tcl could also be run earlier and/or separately, but would incur another Innovus call and related init overheads, so that's why this is merged here
./design_cost.sh

# mark as done
date > DONE.exploit_eval
