//// lec_64 -nogui -xl -dofile lec.do
////
//// template derived from "Sample Dofile" from "Conformal Equivalence Checking User Guide"

// setup
set parallel option -threads 4

read library -both -liberty NangateOpenCellLibrary.lib
read lef file NangateOpenCellLibrary.lef

read design -golden _design_original.v
read design -revised design.v

// Enter LEC mode but w/o auto mapping
set system mode lec -nomap

// To specify pipeline retiming, requires Conformal XL license
analyze retiming

// Map key points automatically
map key points

// Analyzes the netlists and sets up the flattened design for accurate comparison
analyze setup

// To specify datapath analysis, requires Conformal XL license
analyze datapath -merge

// To run key point comparison
add compare point -all
compare

// reports
report verification > check_equivalence.rpt
echo >> check_equivalence.rpt
report statistics >> check_equivalence.rpt
echo >> check_equivalence.rpt
report unmapped points >> check_equivalence.rpt
echo >> check_equivalence.rpt
report compare data >> check_equivalence.rpt
// NOTE redundant report but helps for parsing
report unmapped points >> check_equivalence.rpt.unmapped

// mark done; exit
date > DONE.lec
exit -force
